/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.math;

import com.google.common.collect.Queues;
import java.util.Deque;
import repack.joml.Matrix3f;
import repack.joml.Matrix4f;

public class MatrixStack {
    private final Deque<Entry> matrixStack = Queues.newArrayDeque();

    public MatrixStack() {
        this.matrixStack.add(new Entry(new Matrix4f().identity(), new Matrix3f().identity()));
    }

    public MatrixStack(Matrix4f initial) {
        Matrix3f normal = new Matrix3f();
        this.matrixStack.add(new Entry(initial, initial.normal(normal)));
    }

    public Entry peek() {
        return this.matrixStack.getLast();
    }

    public void push() {
        Entry lv = this.matrixStack.getLast();
        this.matrixStack.addLast(new Entry(new Matrix4f(lv.model), new Matrix3f(lv.normal)));
    }

    public void pop() {
        this.matrixStack.removeLast();
    }

    public boolean clear() {
        return this.matrixStack.size() == 1;
    }

    public void translate(double d, double e, double f) {
        Entry lv = this.matrixStack.getLast();
        lv.model.translateCustom((float)d, (float)e, (float)f);
    }

    public void rotateX(float f) {
        Entry lv = this.matrixStack.getLast();
        lv.model.rotateX(f);
        lv.normal.rotateX(f);
    }

    public void rotateY(float f) {
        Entry lv = this.matrixStack.getLast();
        lv.model.rotateY(f);
        lv.normal.rotateY(f);
    }

    public void rotateZ(float f) {
        Entry lv = this.matrixStack.getLast();
        lv.model.rotateZ(f);
        lv.normal.rotateZ(f);
    }

    public void scale(float f, float g, float h) {
        Entry lv = this.matrixStack.getLast();
        lv.model.scale(f, g, h);
        if (f == g && g == h) {
            if (f > 0.0f) {
                return;
            }
            lv.normal.scale(-1.0f);
        }
        float i = 1.0f / f;
        float j = 1.0f / g;
        float k = 1.0f / h;
        float l = MatrixStack.invSqrt(i * j * k);
        lv.normal.scale(l * i, l * j, l * k);
    }

    private static float invSqrt(float x) {
        float xhalf = 0.5f * x;
        int i = Float.floatToIntBits(x);
        i = 1597463007 - (i >> 1);
        x = Float.intBitsToFloat(i);
        x *= 1.5f - xhalf * x * x;
        return x;
    }

    public static final class Entry {
        private final Matrix4f model;
        private final Matrix3f normal;

        private Entry(Matrix4f model, Matrix3f normal) {
            this.model = model;
            this.normal = normal;
        }

        public Matrix4f getModel() {
            return this.model;
        }

        public Matrix3f getNormal() {
            return this.normal;
        }
    }
}

